package command;

import util.Response;

import java.util.List;

public class EchoCommand implements CommandExecutable<byte[]> {
    private final List<String> args;

    public EchoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (!args.isEmpty()) {
            return (Response.getResponse(args.getFirst()));
        } else {
            return "".getBytes();
        }
    }
}
