package command.replica;


import command.CommandExecutable;
import model.Command;
import parser.CommandParser;
import util.CommandByteCounter;

import java.util.List;

public class ReplicaReplConfCommand implements CommandExecutable<byte[]> {
    private final CommandParser commandParser;
    private final CommandByteCounter commandByteCounter;

    public ReplicaReplConfCommand() {
        commandParser = new CommandParser();
        this.commandByteCounter = CommandByteCounter.getInstance();
    }

    @Override
    public byte[] execute() {
          System.out.println("ReplicaReplConfCommand processed command: ");
        return commandParser.getResponseFromCommandArray(List.of(Command.REPLCONF.getValue(), "ACK", commandByteCounter.getBytes().toString())).getBytes();

    }

}
