package client;

import parser.CommandParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Client extends Thread {
    protected final CommandParser commandParser;
    protected final Socket socket;
    protected BufferedReader reader;
    private static final Logger logger = Logger.getLogger(Client.class.getName());

    protected Client(Socket socket) {
        this.socket = socket;
        this.commandParser = new CommandParser();
    }

    protected Client(BufferedReader reader, Socket socket) {
        this.reader = reader;
        this.commandParser = new CommandParser();
        this.socket = socket;
    }

    @Override
    public void run() {
        try (OutputStream outputStream = socket.getOutputStream()) {
            if (reader == null) {
                reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            }
            handleClient(reader, outputStream);
        } catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    protected abstract void handleClient(BufferedReader bufferedReader, OutputStream outputStream) throws IOException;
}
