package handlers;

import command.CommandHandler;
import command.CommandInvoker;
import factory.CommandFactory;
import model.Command;
import parser.CommandParser;
import util.CommandUtil;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class ClientCommandHandler {
    private final List<String> commands;
    private final OutputStream os;

    public ClientCommandHandler(List<String> commands, OutputStream outputStream) {
        this.commands = commands;
        this.os = outputStream;
        CommandParser commandParser = new CommandParser();
    }


    public boolean execute() {
        Command command = CommandUtil.getCommand(commands.getFirst().split(" ")[0]);
        CommandHandler commandProcessor = new CommandFactory(command).getInstance();
        List<String> commandAndArgs = Arrays.stream(commands.getFirst().split(" ")).toList();
        try {
            CommandInvoker.invoke(commandProcessor, commandAndArgs, os);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }


}
