package command.replica.handshake;

import model.Command;
import parser.CommandParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class PingCommand extends Sender {
    public PingCommand(CommandParser commandParser) {
        super(commandParser);
    }

    @Override
    public void send(BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        byte[] bytes = commandParser.getResponseFromCommandArray(List.of(Command.PING.getValue().toLowerCase())).getBytes();
        outputStream.write(bytes);
        outputStream.flush();
    }
}
