package command;

import storage.Storage;
import util.Response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;


public class GetCommand implements CommandHandler {
    private final Storage storage = Storage.getInstance();


    @Override
    public void execute(List<String> args, OutputStream os) {

        try {
            String response = storage.get(args.getFirst().toLowerCase());
            if (response == null || response.isEmpty() || response.isBlank()) {
                os.write("$-1\r\n".getBytes());
                os.flush();
                return;
            }
            os.write(Response.getResponse(response));
            os.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
