package command;

import model.Command;
import util.Response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InfoCommand implements CommandHandler {
    private final Configuration configuration = Configuration.getInstance();

    @Override
    public void execute(List<String> args, OutputStream os) {
        System.out.println(configuration.getInfo());
        String command = args.getFirst();
        if (command.equalsIgnoreCase(Command.REPLICATION.getValue())) {
            Map<String, String> info = configuration.getInfo();
            String response = info.entrySet()
                    .stream()
                    .map(data -> data.getKey() + ":" + data.getValue())
                    .collect(Collectors.joining());
            try {
                os.write(Response.getResponse(response));
                os.flush();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }


    }
}