package command.replica;

import command.CommandExecutable;
import model.Command;
import parser.CommandParser;

import java.io.IOException;
import java.util.List;

public class ReplicaFullRsyncCommand implements CommandExecutable<byte[]> {
    private final CommandParser commandParser;

    public ReplicaFullRsyncCommand() {
        commandParser = new CommandParser();
    }

    @Override
    public byte[] execute() throws IOException {
        return commandParser.getResponseFromCommandArray(List.of(Command.REPLCONF.getValue(), "ACK", "0")).getBytes();
    }
}
