package client.master;


import client.Client;
import handlers.ClientCommandHandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MasterClient extends Client {
    private static final Logger logger = Logger.getLogger(MasterClient.class.getName());

    public MasterClient(Socket socket) {
        super(socket);

    }

    @Override
    protected void handleClient(BufferedReader bufferedReader, OutputStream outputStream) {
        String line;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                List<String> parsedCommands = commandParser.parseCommand(bufferedReader, line);
                ClientCommandHandler commandHandler = new ClientCommandHandler(parsedCommands, outputStream);
                commandHandler.execute();
            }
        } catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(),e);
        }
    }
}
