package command;

import java.util.List;

public final class CommandValidator {

    private static final CommandValidator INSTANCE = new CommandValidator();

    private CommandValidator() {
    }

    public static CommandValidator getInstance() {
        return INSTANCE;
    }

    public boolean validateSetCommand(List<String> args) {
        if (args == null || args.size() < 2) {
            return false;
        }

        int size = args.size();
        if (size == 2) {
            return true;
        }

        boolean hasPx = false;
        String pxValue = null;

        for (int i = 2; i < size - 1; i += 2) {
            String key = args.get(i).toLowerCase();
            if ("px".equals(key)) {
                hasPx = true;
                pxValue = args.get(i + 1);
                break;
            }
        }

        if (hasPx) {
            return isValidLong(pxValue);
        } else {
            return size % 2 == 0 || isValidLong(args.get(size - 1));
        }
    }

    private boolean isValidLong(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        int len = value.length();
        if (len > 19) {
            return false;
        }
        for (int i = 0; i < len; i++) {
            char c = value.charAt(i);
            if (i == 0 && c == '-') {
                if (len == 1) return false;
                continue;
            }
            if (c < '0' || c > '9') {
                return false;
            }
        }
        return true;
    }

    public boolean validateGetCommand(List<String> args) {
        return args != null && args.size() == 1;
    }

    public boolean validateInfoCommand(List<String> args) {
        return args != null && args.size() == 1 &&
                "replication".equalsIgnoreCase(args.getFirst());
    }

    public boolean validateEchoCommand(List<String> args) {
        return !args.isEmpty() && args.getFirst() != null;
    }
}