import director.Director;
import server.ReplicaConnectionService;
import server.Server;
import server.ServerBuilder;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class Main {
    public static ExecutorService executor;

    public static void main(String[] args) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        executor = Executors.newFixedThreadPool(availableProcessors);

        Director director = new Director();
        ServerBuilder builder = new ServerBuilder(args);

        List<Callable<Void>> tasks = Arrays.asList(
                () -> {
                    try {
                        ReplicaConnectionService service = null;
                        director.buildReplica(builder, service);
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                },
                () -> {
                    try (Server server = builder.build()) {
                        server.start();
                    } catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
        );

        try {
            executor.invokeAll(tasks);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Task execution was interrupted", e);
        } finally {
            shutdownExecutor(executor);
        }
    }

    private static void shutdownExecutor(ExecutorService executor) {
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(60, TimeUnit.SECONDS)) {
                    System.err.println("Executor did not terminate");
                }
            }
        } catch (InterruptedException e) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}
