package command;

import model.Command;
import storage.Storage;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SetCommand implements CommandExecutable<byte[]> {
    private final Storage storage = Storage.getInstance();
    private final List<String> args;

    public SetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        Map<String, String> commandsMap = IntStream.iterate(2, i -> i < args.size(), i -> i + 2)
                .boxed()
                .collect(Collectors.toMap(i -> args.get(i).toLowerCase(), i -> args.get(i + 1), (a, b) -> b));

        String value = args.get(1);
        String expiration = commandsMap.get(Command.PX.getValue().toLowerCase());
        if (expiration != null) {
            try {
                Long expirationTime = Long.parseLong(expiration);
                storage.save(args.getFirst().toLowerCase(), value, expirationTime);
            } catch (NumberFormatException e) {
                System.out.println("NumberFormatException:  " + e.getMessage());
            }
        } else {
            storage.save(args.getFirst().toLowerCase(), value);
        }
        return ("+OK\r\n".getBytes());
    }
}
