package command;

import model.Command;
import server.ReceivedFromReplica;

import java.util.List;

public class ReplConfCommand implements CommandExecutable<byte[]> {
    private final List<String> args;


    public ReplConfCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (args.getFirst().equalsIgnoreCase(Command.ACK.getValue())) {
            return null;
        }

        return ("+OK\r\n".getBytes());

    }
}
