package command;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CommandInvoker {
    private static final Logger logger = Logger.getLogger(CommandInvoker.class.getName());

    public static byte[] invoke(CommandExecutable<byte[]> command) throws IOException {
        String commandClassName = command.getClass().getName();
        String threadName = Thread.currentThread().getName();
        logger.log(Level.INFO, "Executing command: " + commandClassName + " on thread: " + threadName);
        byte[] result = command.execute();
        logger.log(Level.INFO, "Command executed successfully: " + commandClassName);

        return result;
    }
}
