package client.replica;

import client.Client;
import command.CommandProcessable;
import handlers.replica.ReplicaCommandHandler;
import util.CommandByteCounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ReplicaClient extends Client {
    private final CommandByteCounter commandByteCounter;
    private final ExecutorService executorService;

    public ReplicaClient(BufferedReader reader, Socket socket) {
        super(reader, socket);
        System.out.println("Client");
        this.commandByteCounter = CommandByteCounter.getInstance();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @Override
    protected void handleClient(BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        String line;
        System.out.println("Handling");
        while ((line = bufferedReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            List<String> parsedCommands = commandParser.parseCommand(bufferedReader, line);
            System.out.println("ReplicaClient parse: " + parsedCommands);
            addBytes(parsedCommands);
            CommandProcessable commandHandler = new ReplicaCommandHandler(parsedCommands);
            Thread thread = new Thread(commandHandler);
            thread.start();
        }
    }

    private void addBytes(List<String> parsedCommands) {
        if (commandByteCounter.isFirst()) {
            commandByteCounter.setIsFirst(false);
        } else {
            String response = commandParser.getResponseFromCommandArray(parsedCommands);
            commandByteCounter.addBytes(response.getBytes().length);
        }
    }
}
