package command;

import storage.Storage;
import util.Response;

import java.util.List;


public class GetCommand implements CommandExecutable<byte[]> {
    private final Storage storage = Storage.getInstance();
    private final List<String> args;

    public GetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {

        String response = storage.get(args.getFirst().toLowerCase());
        if (response == null || response.isEmpty() || response.isBlank()) {
            return ("$-1\r\n".getBytes());
        }
        return (Response.getResponse(response));
    }
}
