package client.master;


import client.Client;
import handlers.ClientCommandHandler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;

public class MasterClient extends Client {

    public MasterClient(Socket socket) {
        super(socket);

    }

    @Override
    protected void handleClient(BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        String line;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.isEmpty()) continue;
            List<String> parsedCommands = commandParser.parseCommand(bufferedReader, line);
            ClientCommandHandler commandHandler = new ClientCommandHandler(parsedCommands, outputStream);
            commandHandler.execute();
        }
    }
}
