package command.replica;

import command.CommandExecutable;
import model.Command;
import storage.Storage;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ReplicaSetCommand implements CommandExecutable<Void> {
    private final Storage storage = Storage.getInstance();
    private final List<String> args;
    private static final Logger logger = Logger.getLogger(ReplicaSetCommand.class.getName());

    public ReplicaSetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public Void execute() {
        Map<String, String> commandsMap = IntStream.iterate(2, i -> i < args.size(), i -> i + 2).boxed()
                .collect(Collectors.toMap(i -> args.get(i).toLowerCase(), i -> args.get(i + 1), (a, b) -> b));

        String value = args.get(1);

        String expiration = commandsMap.get(Command.PX.getValue().toLowerCase());
        if (expiration != null) {
            try {
                Long expirationTime = Long.parseLong(expiration);
                storage.save(args.getFirst().toLowerCase(), value, expirationTime);
            } catch (NumberFormatException e) {
                logger.log(Level.SEVERE, "NumberFormatException", e);
            }
        } else {
            storage.save(args.getFirst().toLowerCase(), value);
        }
        return null;
    }
}
