package factory;

import command.CommandExecutable;
import factory.replica.ReplicaCommandFactory;
import model.Command;
import org.junit.Test;

import java.util.List;

import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertSame;

public class ReplicaCommandFactoryTest {

    @Test
    public void test_get_instance_returns_same_instance() {
        ReplicaCommandFactory instance1 = ReplicaCommandFactory.getInstance();
        ReplicaCommandFactory instance2 = ReplicaCommandFactory.getInstance();
        assertSame(instance1, instance2);
    }

    @Test
    public void test_get_command_returns_null_for_unknown_command() {
        ReplicaCommandFactory factory = ReplicaCommandFactory.getInstance();
        CommandExecutable<?> commandExecutable = factory.getCommand(Command.UNKNOWN, List.of());
        assertNull(commandExecutable);
    }
}