package command;

import org.junit.Test;
import org.mockito.Mockito;
import storage.Cacheable;
import util.Response;

import java.util.Arrays;
import java.util.List;

import static org.junit.Assert.assertArrayEquals;

public class SetCommandTest {


    @Test
    public void execute_with_valid_args_size_2_returns_ok_response() {
        List<String> args = Arrays.asList("key", "value");
        Cacheable storageMock = Mockito.mock(Cacheable.class);
        SetCommand setCommand = new SetCommand(args);
        byte[] expectedResponse = "+OK\r\n".getBytes();
        byte[] actualResponse = setCommand.execute();
        assertArrayEquals(expectedResponse, actualResponse);
    }

    @Test
    public void execute_with_null_args_returns_error_response() {
        List<String> args = null;
        Cacheable storageMock = Mockito.mock(Cacheable.class);
        SetCommand setCommand = new SetCommand(args);
        byte[] expectedResponse = Response.getResponse("wrong args");
        byte[] actualResponse = setCommand.execute();
        assertArrayEquals(expectedResponse, actualResponse);
    }
}