package command.replica;

import command.CommandExecutable;
import storage.Cacheable;
import storage.Storage;

import java.util.List;

public final class ReplicaSetCommand implements CommandExecutable<Void> {
    private final Cacheable<String, String> storage = Storage.getInstance();
    private final List<String> args;

    public ReplicaSetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public Void execute() {
        String key = args.get(0).toLowerCase();
        String value = args.get(1);

        int size = args.size();
        if (size > 2) {
            String lastArg = args.get(size - 1);
            if (size % 2 == 0) {
                if ("px".equalsIgnoreCase(args.get(size - 2))) {
                    long expirationTime = Long.parseLong(lastArg);
                    storage.save(key, value, expirationTime);
                } else {
                    storage.save(key, value);
                }
            } else {
                long expirationTime = Long.parseLong(lastArg);
                storage.save(key, value, expirationTime);
            }
        } else {
            storage.save(key, value);
        }
        return null;
    }
}