package command;

import command.validation.GetCommandValidator;
import command.validation.Validatable;
import storage.Cacheable;
import storage.Storage;
import util.Response;

import java.util.List;


public final class GetCommand implements CommandExecutable<byte[]> {
    private final Cacheable<String, String> storage = Storage.getInstance();
    private static final byte[] ERROR_RESPONSE = Response.getResponse("wrong args");
    private final List<String> args;
    private final Validatable validator = GetCommandValidator.getInstance();

    public GetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (!validator.isValid(args)) {
            return ERROR_RESPONSE;
        }
        String response = storage.get(args.getFirst().toLowerCase());
        if (response == null || response.isEmpty() || response.isBlank()) {
            return ("$-1\r\n".getBytes());
        }
        return (Response.getResponse(response));
    }
}
