package factory.replica;

import command.CommandExecutable;
import command.replica.ReplicaFullRsyncCommand;
import command.replica.ReplicaReplConfCommand;
import command.replica.ReplicaSetCommand;
import factory.Factory;
import model.Command;

import java.util.List;

public class ReplicaCommandFactory implements Factory {
    private static final class ReplicaFactoryHolder {
        private static final ReplicaCommandFactory factory = new ReplicaCommandFactory();
    }

    public ReplicaCommandFactory() {
    }

    public static ReplicaCommandFactory getInstance() {
        return ReplicaFactoryHolder.factory;
    }

    @Override
    public CommandExecutable<?> getCommand(Command command, List<String> args) {
        return switch (command) {
            case SET -> new ReplicaSetCommand(args);
            case REPLCONF -> new ReplicaReplConfCommand();
            case PSYNC, FULLRESYNC -> new ReplicaFullRsyncCommand();
            default -> null;
        };
    }
}
