package util;


import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class CommandByteCounter {
    private final AtomicInteger bytes;
    private final AtomicBoolean isFirst;

    private CommandByteCounter() {
        bytes = new AtomicInteger(0);
        isFirst = new AtomicBoolean(true);
    }

    private static final class InstanceHolder {
        private static final CommandByteCounter instance = new CommandByteCounter();
    }

    public static CommandByteCounter getInstance() {
        return InstanceHolder.instance;
    }

    public void setIsFirst(boolean b) {
        isFirst.set(b);
    }

    public boolean isFirst() {
        return isFirst.get();
    }


    public void addBytes(int bytesLength) {
        bytes.addAndGet(bytesLength);
    }


    public Integer getBytes() {
        return bytes.get();
    }
}