package handlers.replica;

import command.handshake.CommandSender;
import command.handshake.PingCommandSender;
import command.handshake.ReplConfCommandSender;
import model.Command;
import parser.CommandParser;
import util.RdbBytesReader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConnectionHandler {
    private static final Logger logger = Logger.getLogger(ConnectionHandler.class.getName());

    private final Socket socket;
    private final RdbBytesReader reader;
    private final int port;
    private final CommandParser commandParser;
    private CommandSender commandSender;

    public ConnectionHandler(Socket socket, CommandParser commandParser, int port) {
        this.socket = socket;
        this.commandSender = new PingCommandSender(commandParser);
        this.port = port;
        this.reader = new RdbBytesReader();
        this.commandParser = commandParser;
    }

    public BufferedReader handleConnection() {
        try {
            OutputStream outputStream = socket.getOutputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            commandSender.sendCommand(bufferedReader, outputStream);
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) {
                    continue;
                }

                logger.info("Processing line: " + line);

                if (line.equalsIgnoreCase("+" + Command.PONG.getValue())) {
                    this.commandSender = new ReplConfCommandSender(String.valueOf(port), commandParser);
                    commandSender.sendCommand(bufferedReader, outputStream);
                } else if (line.startsWith("+FULLRESYNC")) {
                    return reader.read(bufferedReader);
                }
            }
        } catch (IOException e) {
            logger.log(Level.SEVERE, "I/O error during connection handling: " + e.getMessage(), e);
        } catch (Exception e) {
            logger.log(Level.SEVERE, "Unexpected error during connection handling: " + e.getMessage(), e);
        }
        return null;
    }
}
