package storage;

import jdk.incubator.vector.ByteVector;
import jdk.incubator.vector.VectorMask;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Storage {
    private final Map<String, String> storage = new ConcurrentHashMap<>(10000);
    private final Map<String, Long> timeToExpiration = new ConcurrentHashMap<>(10000);
    private final Map<String, Long> currentTimeForKey = new ConcurrentHashMap<>(10000);

    private static final VectorSpecies<Byte> SPECIES = ByteVector.SPECIES_128;

    private Storage() {
        //    RdbFileReader reader = new RdbFileReader();
        //Map<String, String> stringStringMap = reader.readFile();
        //  storage.putAll(stringStringMap);
        //Map<String, Long> keysExpiration = reader.getKeysExpiration();
        //  timeToExpiration.putAll(keysExpiration);
    }

    private static final class StorageHolder {
        private static final Storage storage = new Storage();
    }

    public static Storage getInstance() {
        return StorageHolder.storage;
    }

    public void save(String key, String value) {
        storage.put(key, value);
    }

    public void save(String key, String value, Long time) {
        System.out.println("SAVE Storage: " + key);
        currentTimeForKey.put(key, System.currentTimeMillis());
        timeToExpiration.put(key, time);
        save(key, value);
    }

    public String get(String key) {
        System.out.println("GET Storage: " + key);

        if (isExpired(key)) {
            System.out.println("Key expired: " + key);
            return "";
        }

        return storage.get(key);
    }

    private boolean isExpired(String key) {
        long currentTime = System.currentTimeMillis();

        if (timeToExpiration.containsKey(key)) {
            long expirationTime = timeToExpiration.get(key);

            if (currentTimeForKey.containsKey(key)) {
                long currExpiration = currentTimeForKey.get(key);
                long timeDiff = currentTime - currExpiration;
                return vectorizedComparison(timeDiff, expirationTime);
            } else {
                return vectorizedComparison(currentTime, expirationTime);
            }
        }
        return false;
    }

    private boolean vectorizedComparison(long timeDiff, long expirationTime) {
        // Convert timeDiff and expirationTime to byte arrays for SIMD processing
        byte[] timeDiffBytes = longToBytes(timeDiff);
        byte[] expirationTimeBytes = longToBytes(expirationTime);

        ByteVector timeDiffVector = ByteVector.fromArray(SPECIES, timeDiffBytes, 0);
        ByteVector expirationTimeVector = ByteVector.fromArray(SPECIES, expirationTimeBytes, 0);


        VectorMask<Byte> mask = timeDiffVector.compare(VectorOperators.GT, expirationTimeVector);

        return mask.anyTrue();
    }

    private byte[] longToBytes(long value) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; i--) {
            bytes[i] = (byte) (value & 0xFF);
            value >>= 8;
        }
        return bytes;
    }

}
