package handlers;

import command.CommandHandler;
import command.CommandInvoker;
import factory.CommandFactory;
import model.Command;
import util.CommandUtil;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ClientCommandHandler {
    private final List<String> commands;
    private final OutputStream os;
    private final CommandFactory factory = CommandFactory.getInstance();

    public ClientCommandHandler(List<String> commands, OutputStream outputStream) {
        this.commands = commands;
        this.os = outputStream;
    }


    public void execute() {
        Command command = CommandUtil.getCommand(commands.getFirst());
        commands.removeFirst();
        CommandHandler commandProcessor = factory.getCommand(command, commands);
        try {
            byte[] result = CommandInvoker.invoke(commandProcessor);
            os.write(result);
            os.flush();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
