package factory;

import command.*;
import model.Command;

import java.util.List;

public class CommandFactory implements Factory {

    private static final class FactoryHolder {
        private static final CommandFactory factory = new CommandFactory();
    }

    public CommandFactory() {
    }

    public static CommandFactory getInstance() {
        return FactoryHolder.factory;
    }

    @Override
    public CommandHandler getCommand(Command command, List<String> args) {
        return switch (command) {
            case PING -> new PingCommand();
            case ECHO -> new EchoCommand(args);
            case SET -> new SetCommand(args);
            case GET -> new GetCommand(args);
            case INFO -> new InfoCommand(args);
//            case REPLCONF -> new ReplConfCommand(replicaReceiver);
//            case PSYNC -> new FullResyncCommandProcessor(replicaSender);
//            case WAIT -> new WaitCommandProcessor(replicaSender, replicaReceiver);
//            case CONFIG -> new ConfigCommandProcessor();
//            case KEYS -> new KeysCommandProcessor();
//            case TYPE -> new TypeCommandProcessor();
//            case XADD -> new XaddCommandProcessor();
//            case XRANGE -> new XrangeCommandProcessor();
//            case XREAD -> new XreadCommandProcessor();
//            case INCR -> new IncrCommandProcessor();
//            case MULTI -> new MultiCommandProcessor(transactionMultiCommandService);
//            case EXEC -> new ExecCommandProcessor(transactionMultiCommandService);
//            case DISCARD -> new DiscardCommandProcessor(transactionMultiCommandService);
            default -> new UnknownCommand();
        };
    }

}
