package command;

import model.Command;
import util.Response;
import util.ServerInfo;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InfoCommand implements CommandHandler {
    private final ServerInfo configuration = ServerInfo.getInstance();
    List<String> args;

    public InfoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        String command = args.getFirst();
        if (command.equalsIgnoreCase(Command.REPLICATION.getValue())) {
            Map<String, String> info = configuration.getInfo();
            String response = info.entrySet()
                    .stream()
                    .map(data -> data.getKey() + ":" + data.getValue())
                    .collect(Collectors.joining());
            return Response.getResponse(response);
        }
        return null;
    }
}