package storage;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StorageManager {
    private final Storage storage;
    private final ScheduledExecutorService scheduler;

    public StorageManager() {
        this.storage = Storage.getInstance();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(this::performMaintenance, 2, 2, TimeUnit.MINUTES);
    }

    private void performMaintenance() {
        storage.runCachePolicy();
        System.out.println("Maintenance performed at: " + Date.from(java.time.Clock.systemUTC().instant()));
    }

    public void shutdown() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(20, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        } catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }
}