package storage;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class StorageManager {
    private final Storage storage;
    private final ScheduledExecutorService scheduler;

    public StorageManager() {
        this.storage = Storage.getInstance();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(this::performMaintenance, 5, 5, TimeUnit.MINUTES);
    }

    public Storage getStorage() {
        return storage;
    }

    private void performMaintenance() {
        storage.runCachePolicy();
        System.out.println("Maintenance performed at: " + System.currentTimeMillis());
    }

    public void shutdown() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(60, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        } catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }
}