package command.handshake;

import model.Command;
import parser.CommandParser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PingCommandSender extends CommandSender {
    private static final Logger logger = Logger.getLogger(PingCommandSender.class.getName());

    public PingCommandSender(CommandParser commandParser) {
        super(commandParser);
    }

    @Override
    public void sendCommand(BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        try {
            logger.info("Sending PING command.");

            byte[] bytes = commandParser.getResponseFromCommandArray(
                    List.of(Command.PING.getValue().toLowerCase())).getBytes();
            outputStream.write(bytes);
            outputStream.flush();

            logger.info("PING command sent successfully.");
        } catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to send PING command: " + e.getMessage(), e);
            throw new IOException("Failed to send PING command: " + e.getMessage(), e);
        }
    }
}
