package client.replica;

import client.Client;
import command.CommandProcessable;
import handlers.replica.ReplicaCommandHandler;
import util.CommandByteCounter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaClient extends Client {
    private final CommandByteCounter commandByteCounter;
    private final ExecutorService executorService;
    private static final Logger logger = Logger.getLogger(ReplicaClient.class.getName());

    public ReplicaClient(BufferedReader reader, Socket socket) {
        super(reader, socket);
        this.commandByteCounter = CommandByteCounter.getInstance();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @Override
    protected void handleClient(BufferedReader bufferedReader, OutputStream outputStream) {
        String line;
        try {
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty()) continue;
                List<String> parsedCommands = commandParser.parseCommand(bufferedReader, line);
                addBytes(parsedCommands);
                CommandProcessable command = new ReplicaCommandHandler(parsedCommands);
                executorService.submit(command);
            }
        } catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(),e);
        }
    }

    private void addBytes(List<String> parsedCommands) {
        if (commandByteCounter.isFirst()) {
            commandByteCounter.setIsFirst(false);
        } else {
            String response = commandParser.getResponseFromCommandArray(parsedCommands);
            commandByteCounter.addBytes(response.getBytes().length);
        }
    }
}
