package command;

import util.Response;

import java.util.List;

public class EchoCommand implements CommandExecutable<byte[]> {
    private final List<String> args;
    private final CommandValidator validator = CommandValidator.getInstance();

    public EchoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (validator.validateEchoCommand(args)) {
            return (Response.getResponse(args.getFirst()));
        } else {
            return "".getBytes();
        }
    }
}
