package handlers;

import command.CommandHandler;
import command.CommandInvoker;
import factory.CommandFactory;
import model.Command;
import parser.CommandParser;
import util.CommandUtil;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ClientCommandHandler {
    private final List<String> commands;
    private final OutputStream os;

    public ClientCommandHandler(List<String> commands, OutputStream outputStream) {
        this.commands = commands;
        this.os = outputStream;
        CommandParser commandParser = new CommandParser();
    }


    public boolean execute() {
        Command command = CommandUtil.getCommand(commands.getFirst());
        System.out.println(command);
        System.out.println("Command " + commands);
        CommandHandler commandProcessor = new CommandFactory(command).getInstance();
        try {
            CommandInvoker.invoke(commandProcessor, commands, os);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }


}
