package command;

import model.Command;
import server.ServerInfo;
import util.Response;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InfoCommand implements CommandExecutable<byte[]> {
    private final ServerInfo configuration = ServerInfo.getInstance();
    private final CommandValidator validator = CommandValidator.getInstance();
    List<String> args;

    public InfoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (!validator.validateInfoCommand(args)) {
            return "unsupported  args".getBytes();
        }
        String command = args.getFirst();
        if (command.equalsIgnoreCase(Command.REPLICATION.getValue())) {
            Map<String, String> info = configuration.getInfo();
            String response = info.entrySet()
                    .stream()
                    .map(data -> data.getKey() + ":" + data.getValue())
                    .collect(Collectors.joining());
            return Response.getResponse(response);
        }
        return null;
    }
}