import director.Director;
import server.Server;
import server.ServerBuilder;
import util.Settings;

import java.util.Map;

public class Main {

    public static void main(String[] args) {
        Map<String, String> parameters = Settings.extractArgs(args);
        int port = 6379;
        port = Settings.extractPort(parameters, port);
        Director director = new Director();
        ServerBuilder builder = new ServerBuilder();
        director.buildMaster(builder);
        builder.setPort(port);
        try (Server server = builder.build()) {
            server.start();
        }
    }
}