package command;

import org.junit.Test;

import static org.junit.Assert.assertArrayEquals;
import static org.junit.Assert.assertNotNull;

public class PingCommandTest {


    @Test
    public void test_execute_returns_correct_pong_response() {
        PingCommand pingCommand = new PingCommand();
        byte[] expectedResponse = "+PONG\r\n".getBytes();
        byte[] actualResponse = pingCommand.execute();
        assertArrayEquals(expectedResponse, actualResponse);
    }

    @Test
    public void test_execute_handles_null_values_gracefully() {
        PingCommand pingCommand = new PingCommand();
        byte[] response = pingCommand.execute();
        assertNotNull(response);
    }
}