package client;

import client.replica.ReplicaClient;
import org.junit.Test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

import static org.mockito.Mockito.*;

public class ReplicaClientTest {

    @Test
    public void test_readLine_returns_null() throws IOException {
        Socket mockSocket = mock(Socket.class);
        BufferedReader mockReader = mock(BufferedReader.class);
        OutputStream mockOutputStream = mock(OutputStream.class);
        when(mockSocket.getOutputStream()).thenReturn(mockOutputStream);
        when(mockReader.readLine()).thenReturn(null);

        ReplicaClient replicaClient = new ReplicaClient(mockReader, mockSocket);
        replicaClient.run();

        verify(mockReader, times(1)).readLine();
        verify(mockOutputStream, never()).write(any(byte[].class));
    }
}