package command;



import org.junit.Test;

import java.util.List;

import static org.junit.Assert.*;

public class InfoCommandTest {

    @Test
    public void test_valid_command_with_correct_argument() {
        List<String> args = List.of("replication");
        InfoCommand infoCommand = new InfoCommand(args);
        byte[] response = infoCommand.execute();
        String expectedResponse = "$20\r\nrole:mastercachePolicyName:caffeine\r\n";
        assertArrayEquals(expectedResponse.getBytes(), response);
    }

    @Test
    public void test_null_argument_list() {
        List<String> args = null;
        InfoCommand infoCommand = new InfoCommand(args);
        byte[] response = infoCommand.execute();
        String expectedResponse = "$16\r\nunsupported args\r\n";
        assertArrayEquals(expectedResponse.getBytes(), response);
    }
}