package storage;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageManager {
    private final Cacheable<String,String> storage;
    private final ScheduledExecutorService scheduler;
    private static final Logger logger = Logger.getLogger(StorageManager.class.getName());

    public StorageManager() {
        this.storage = Storage.getInstance();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.scheduleAtFixedRate(this::performMaintenance, 30, 30, TimeUnit.SECONDS);
    }

    private void performMaintenance() {
        storage.runCachePolicy();
        logger.log(Level.INFO, "Maintenance Started");
    }

    public void shutdown() {
        scheduler.shutdown();
        try {
            if (!scheduler.awaitTermination(20, TimeUnit.SECONDS)) {
                scheduler.shutdownNow();
            }
        } catch (InterruptedException e) {
            scheduler.shutdownNow();
        }
    }
}