package command;

import command.validation.EchoCommandValidator;
import command.validation.Validatable;
import util.Response;

import java.util.List;

public final class EchoCommand implements CommandExecutable<byte[]> {
    private final List<String> args;
    private final Validatable validator = EchoCommandValidator.getInstance();

    public EchoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (validator.isValid(args)) {
            return (Response.getResponse(args.getFirst()));
        } else {
            return "".getBytes();
        }
    }
}
