package command;

import command.validation.InfoCommandValidator;
import command.validation.Validatable;
import server.ServiceInfo;
import util.Response;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class InfoCommand implements CommandExecutable<byte[]> {
    private final ServiceInfo configuration = ServiceInfo.getInstance();
    private final Validatable validator = InfoCommandValidator.getInstance();
    List<String> args;

    public InfoCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (!validator.isValid(args)) {
            return Response.getResponse("unsupported args");
        }
        String command = args.getFirst();
        Map<String, String> info = configuration.getInfo();
        String response = info.entrySet()
                .stream()
                .map(data -> data.getKey() + ":" + data.getValue())
                .collect(Collectors.joining());
        return Response.getResponse(response);
    }
}