package client;


import client.master.MasterClient;
import org.junit.Test;

import java.io.*;
import java.net.Socket;

import static org.mockito.Mockito.*;

public class MasterClientTest {


    @Test
    public void test_successful_connection_and_command_processing() throws IOException {
        Socket socket = mock(Socket.class);
        BufferedReader reader = new BufferedReader(new StringReader("COMMAND\n"));
        OutputStream outputStream = mock(OutputStream.class);
        when(socket.getInputStream()).thenReturn(new ByteArrayInputStream("COMMAND\n".getBytes()));
        when(socket.getOutputStream()).thenReturn(outputStream);

        MasterClient masterClient = new MasterClient(socket);
        masterClient.run();

        verify(outputStream, times(1)).write(any(byte[].class));
        verify(outputStream, times(1)).flush();
    }

    @Test
    public void test_handle_client_with_null_buffered_reader() throws IOException {
        Socket socket = mock(Socket.class);
        OutputStream outputStream = mock(OutputStream.class);
        when(socket.getInputStream()).thenReturn(new ByteArrayInputStream("COMMAND\n".getBytes()));
        when(socket.getOutputStream()).thenReturn(outputStream);

        MasterClient masterClient = new MasterClient(socket);
        masterClient.run();

        verify(outputStream, times(1)).write(any(byte[].class));
        verify(outputStream, times(1)).flush();
    }
}