package storage;

public interface Cacheable<K, V> {
    void save(K key, V value);
    void save(K key, V value, Long expirationTime);
    V get(K key);
    void delete(K key);
    void runCachePolicy();
}
