package storage;

import server.ServiceInfo;

public class CachePolicyFactory {
    private static final ServiceInfo serviceInfo = ServiceInfo.getInstance();

    public static CachePolicy<String, String> getPolicy(int capacity) {
        if (serviceInfo.getInfo().get("cachePolicyName").equals("caffeine")) {
            return new CaffeineCachePolicy<>(capacity);
        } else if (serviceInfo.getInfo().get("cachePolicyName").equals("lru")) {
            return new LRUCachePolicy<>(capacity, 800000);
        }
        throw new IllegalArgumentException("Invalid CachePolicy name");
    }
}
