package server;

import util.RdbFileInfo;
import util.Settings;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;

public  final class ServerBuilder {
    private static final Logger logger = Logger.getLogger(ServerBuilder.class.getName());
    private int port = 6379;
    private String role = "master";
    private String[] masterPortAndHost;
    private final ServiceInfo serviceInfo;
    private final RdbFileInfo rdbFileInfo;
    private final Map<String, String> parameters;
    private ReplicaConnectionService replicaConnectionService;

    public ServerBuilder(String[] args) {
        logger.info("Initializing ServerBuilder");
        this.parameters = Settings.extractArgs(args);
        this.port = Settings.extractPort(parameters, port);
        this.serviceInfo = ServiceInfo.getInstance();
        this.rdbFileInfo = RdbFileInfo.getInstance();
        initializeFromParameters();
    }

    public ServerBuilder setPort(int port) {
        logger.info("Setting port to " + port);
        this.port = port;
        return this;
    }

    public ServerBuilder setRole(String role) {
        logger.info("Setting role to " + role);
        this.role = role;
        return this;
    }

    public String[] getMasterPortAndHost() {
        return masterPortAndHost;
    }

    public Server build() throws IOException {
        logger.info("Building Server instance");
        if ("slave".equals(role) && masterPortAndHost != null) {
            this.replicaConnectionService = new ReplicaConnectionService(masterPortAndHost, port);
        }
        return new Server(port, role, replicaConnectionService);
    }

    private void initializeFromParameters() {
        logger.info("Initializing from parameters");
        rdbFileInfo.setFile(parameters);
        this.masterPortAndHost = serviceInfo.findRole(parameters);
        this.role = serviceInfo.getRole();
        logger.info("Initialized with role: " + role);
    }
}
