package command;

import command.validation.SetCommandValidator;
import command.validation.Validatable;
import storage.Cacheable;
import storage.Storage;
import util.Response;

import java.util.List;

public final class SetCommand implements CommandExecutable<byte[]> {
    private static final byte[] OK_RESPONSE = "+OK\r\n".getBytes();
    private static final byte[] ERROR_RESPONSE = Response.getResponse("wrong args");
    private final Cacheable<String, String> storage = Storage.getInstance();
    private final List<String> args;
    private final Validatable validator = SetCommandValidator.getInstance();

    public SetCommand(List<String> args) {
        this.args = args;
    }

    @Override
    public byte[] execute() {
        if (!validator.isValid(args)) {
            return ERROR_RESPONSE;
        }
        String key = args.get(0).toLowerCase();
        String value = args.get(1);

        int size = args.size();
        if (size > 2) {
            String lastArg = args.get(size - 1);
            try {
                if (size % 2 == 0) {
                    if ("px".equalsIgnoreCase(args.get(size - 2))) {
                        long expirationTime = Long.parseLong(lastArg);
                        storage.save(key, value, expirationTime);
                    } else {
                        storage.save(key, value);
                    }
                } else {
                    long expirationTime = Long.parseLong(lastArg);
                    storage.save(key, value, expirationTime);
                }
            } catch (NumberFormatException e) {
                return ERROR_RESPONSE;
            }
        } else {
            storage.save(key, value);
        }

        return OK_RESPONSE;
    }
}