package server;

import client.Client;
import client.primary.MasterClient;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Server {
    private  final int PORT ;
    private final ExecutorService executor;
    private final String role;

    private static Server instance;

    Server(int port, String role) {
        PORT = port;
        this.role = role;
        this.executor = Executors.newVirtualThreadPerTaskExecutor();
    }

    public static synchronized Server getInstance(int PORT,String role) throws IOException {
        if (instance == null) {
            instance = new Server(PORT,role);
        }
        return instance;
    }

    public void start() {
        try (ServerSocket serverSocket = new ServerSocket(PORT)) {
            System.out.println("Server started on port " + PORT);

            while (true) {
                serverSocket.setReuseAddress(true);
                Socket clientSocket = serverSocket.accept();
                System.out.println("New client connected: " + clientSocket.getRemoteSocketAddress());
                handleClient(clientSocket);
            }
        } catch (IOException e) {
            e.getStackTrace();
            System.out.println("Server failed to handle: " + e.getMessage());
        }
    }

    private void handleClient(Socket clientSocket) {
        executor.submit(() -> {
            Client task = new MasterClient(clientSocket);
            task.run();
        });
    }
}
