package builder;

import server.Server;

import java.io.IOException;

public class ServerBuilder {
    private int port;
    private String role;

    public void port(int port) {
        this.port = port;
    }

    public void role(String role) {
        this.role = role;
    }

    public Server build() {
        try {
            return Server.getInstance(port, role);
        } catch (IOException e) {
            throw new RuntimeException("Failed to build the Server");
        }
    }
}
